/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.predefined;

import com.wuest.prefab.Tuple;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildingMethods;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.BasicStructureConfiguration;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.predefined.StructureAlternateStart;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureBasic
extends Structure {
    BlockPos customBlockPos = null;
    private final ArrayList<Tuple<BlockPos, BlockPos>> bedPositions = new ArrayList();

    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, World world, BlockPos originalPos, EnumFacing assumedNorth, Block foundBlock, IBlockState blockState, EntityPlayer player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        if (foundBlock instanceof BlockHopper && config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AdvancedCoop.getName())) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof BlockTrapDoor && config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance.getName())) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof BlockBed && config.chosenOption.getHasBedColor()) {
            BlockPos bedHeadPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            BlockPos bedFootPosition = block.getSubBlock().getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            this.bedPositions.add(new Tuple<BlockPos, BlockPos>(bedHeadPosition, bedFootPosition));
            return true;
        }
        if (foundBlock.getRegistryName().func_110624_b().equals(Blocks.field_150399_cn.getRegistryName().func_110624_b()) && foundBlock.getRegistryName().func_110623_a().equals(Blocks.field_150399_cn.getRegistryName().func_110623_a()) && config.chosenOption.getHasGlassColor()) {
            blockState = this.getStainedGlassBlock(config.glassColor);
            block.setBlockState(blockState);
            this.priorityOneBlocks.add(block);
            return true;
        }
        if (foundBlock.getRegistryName().func_110624_b().equals(Blocks.field_150397_co.getRegistryName().func_110624_b()) && foundBlock.getRegistryName().func_110623_a().equals(Blocks.field_150397_co.getRegistryName().func_110623_a()) && config.chosenOption.getHasGlassColor()) {
            blockState = this.getStainedGlassPaneBlock(config.glassColor);
            BuildBlock.SetBlockState(configuration, world, originalPos, assumedNorth, block, foundBlock, blockState, this);
            this.priorityOneBlocks.add(block);
            return true;
        }
        return false;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, World world, BlockPos originalPos, EnumFacing assumedNorth, EntityPlayer player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        if (this.customBlockPos != null) {
            if (config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AdvancedCoop.getName())) {
                for (int i = 0; i < 4; ++i) {
                    EntityChicken entity = new EntityChicken(world);
                    entity.func_70107_b((double)this.customBlockPos.func_177958_n(), (double)this.customBlockPos.func_177984_a().func_177956_o(), (double)this.customBlockPos.func_177952_p());
                    world.func_72838_d((Entity)entity);
                }
            } else if (config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.ChickenCoop.getName())) {
                EntityChicken entity = new EntityChicken(world);
                entity.func_70107_b((double)this.customBlockPos.func_177958_n(), (double)this.customBlockPos.func_177977_b().func_177956_o(), (double)this.customBlockPos.func_177952_p());
                world.func_72838_d((Entity)entity);
            } else if (config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance.getName())) {
                StructureAlternateStart.PlaceMineShaft(world, this.customBlockPos.func_177977_b(), configuration.houseFacing, true);
            }
            this.customBlockPos = null;
        }
        if (this.bedPositions.size() > 0) {
            for (Tuple<BlockPos, BlockPos> bedPosition : this.bedPositions) {
                BuildingMethods.PlaceColoredBed(world, bedPosition.getFirst(), bedPosition.getSecond(), config.bedColor);
            }
        }
        if (config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AquaBase.getName())) {
            BlockPos airPos = originalPos.func_177981_b(4).func_177967_a(configuration.houseFacing.func_176734_d(), 1);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177977_b();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177977_b();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177977_b();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177972_a(configuration.houseFacing.func_176734_d()).func_177984_a();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177984_a();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177984_a();
            world.func_175698_g(airPos);
        }
    }
}

